﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


/* LINQ introduction 
   A LINQ query operation is performed in three steps. 
   LINQ query operations are strongly-typed 
   Type relationship rules in a LINQ query operation.*/
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }


        /* A LINQ query operation is performed in three steps.  
         
           A LINQ query starts with a from clause and ends with a select or group..by clause.  
         */
        private void button1_Click(object sender, EventArgs e)
        {
            // 1. define the datasource
            int[] numbers = { 8, 5, 2, 9, 3, 0, 7, 1, 6, 4 };

            // 2. construct the query 
            var q = from n in numbers
                    where n < 5
                    orderby n
                    select n;

            string S = "";

            // 3. execute the query 
            foreach (int num in q)
                S += num.ToString() + Environment.NewLine;

            MessageBox.Show(S);
        }



        class Country
        {
            public string Code;
            public string Name;
        }



        /* LINQ query operations are strongly-typed. 
           Type relationship rules in a LINQ query operation. */
        private void button2_Click(object sender, EventArgs e)
        {
            // 1. datasource
            List<Country> countries = new List<Country>
            {
                new Country {Code = "ES", Name = "Spain"},
                new Country {Code = "CZ", Name = "Czech Republic"},
                new Country {Code = "GR", Name = "Greece"},
                new Country {Code = "DK", Name = "Denmark"},
                new Country {Code = "CY", Name = "Cyprus"}
            };


            // 2. query
            var q = from c in countries
                    where c.Code.StartsWith("C")
                    select c.Name;

            string S = "";


            // 3. execution
            foreach (var countryName in q)
                S += countryName + Environment.NewLine;

            MessageBox.Show(S);
        }
    }
}
